# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

KitCLA is a Go-based UI component library that follows atomic design principles. It provides a hierarchical component system with atoms, molecules, and organisms, built on top of a custom HTML generation framework called "goc".

## Development Commands

### Testing
```bash
go test ./...                    # Run all tests
go test ./tests/atoms/...        # Run tests for specific component group
go test -v ./tests/atoms/buttons/button_test.go  # Run specific test file with verbose output
```

### Building
```bash
go build                         # Build the project
go run tools/generator/main.go   # Run the component generator tool
```

## Architecture

### Core Components

1. **goc (Go Component)** - Custom HTML generation framework located in `goc/goc.go`
   - Provides HTML element creation with `H()` function
   - Supports attributes, unsafe content injection, and self-closing tags
   - Foundation for all UI components

2. **Component Base** - Located in `components/component.go`
   - Base struct for all UI components with debug capabilities
   - Provides helper methods like `H()`, `Cc()`, `Ccv()`, `Cs()`, etc.
   - Wrapper methods for common div operations (`Dcs()`, `Ds()`, `Da()`, etc.)

3. **Kit Structure** - Main entry point in `kit.go`
   - Organizes components into Atoms, Molecules, and Organisms
   - Factory pattern with `New()` function that wires all dependencies
   - Components are organized hierarchically following atomic design

### Component Hierarchy

- **Atoms**: Basic building blocks (buttons, inputs, cells, icons, etc.)
- **Molecules**: Simple combinations of atoms (alerts, messages, navbars, etc.)
- **Organisms**: Complex combinations (tables, forms, cards, modals, etc.)

### Data Types

- **dat/entity.go**: Defines `Entity` interface with `GetId()` method
- **dat/**: Contains data structures for forms, tables, and messages

### Testing Structure

- Tests are located in `tests/` directory, mirroring the component structure
- Each test file includes component instantiation via `kitcla.New()`
- Tests verify HTML output using `goc.RenderRoot()`
- Test data files are stored in `data/` subdirectories

### Assets and Frontend

- `assets/` contains JavaScript, CSS, and component files
- Uses Alpine.js (3.8.1) and Tailwind CSS
- Components support both server-side and client-side rendering

## Key Patterns

1. **Component Initialization**: Always use `kitcla.New()` to get a properly initialized Kit
2. **HTML Generation**: Use the base `Component.H()` method or its shortcuts (`Cc`, `Ccv`, `Cs`, etc.)
3. **Testing**: Import the kit, create components, render with `goc.RenderRoot()`, and compare output
4. **Styling**: Components use Tailwind CSS classes via the `css` parameter in helper methods

## Directory Structure

- `components/`: Component implementations organized by atomic design levels
- `tests/`: Test files mirroring component structure
- `goc/`: HTML generation framework
- `dat/`: Data structures and interfaces
- `assets/`: Frontend assets (JS, CSS)
- `docs/`: Component documentation with HTML/JSON examples
- `tools/generator/`: Code generation utilities
- `sup/`: Support utilities for testing and development